## 1\. Сформировать описание CJM для сценария «Создание виджета» и сформировать план отслеживания событий для сценария

В качестве продуктового аналитика ваша задача — создать описание карты взаимодействия пользователя (CJM) и план отслеживания событий для сценария оформления первой платной подписки в сервисе Elfsight (<https://elfsight.com/>).

Оформление первой платной подписки является ключевым процессом нашей модели продукта, поскольку от этого момента мы начинаем монетизировать наши услуги и строить взаимоотношения с платежеспособными клиентами. Этот процесс включает в себя регистрацию на сайте, создание виджет, выбор тарифного плана и другие этапы

Основная цель — определить все ключевые точки соприкосновения пользователя с продуктом на пути к оформлению первой платной подписки и создать детализированный план отслеживания событий для наблюдения за поведением пользователей в процессе. Собираемые в рамках этого задания данные **должны позволять выдвигать обоснованные гипотезы** о потенциальных точках роста конверсии в платные подписки.

**Порядок выполнения:**

1. Пройдите внутри сервиса Elfsight сценарий оформления первой платной подписки (до момента оплаты). Основываясь на своем понимании этого сценария, создайте подробный CJM, который фиксирует значимые на ваш взгляд точки соприкосновения и взаимодействия между пользователем и продуктом в рамках оформления первой платной подписки.
2. Создайте план отслеживания событий на основе CJM, который фиксирует все значимые взаимодействия пользователя в процессе. План отслеживания должен позволять команде разработки однозначно и быстро внедрить отслеживание событий.
3. Приоритизируйте события в плане отслеживания в зависимости от их значимости для пути пользователя и целей продукта. Ваша цель — дать команде стейкхолдеров, разработчиков и аналитиков указания, позволяющие сосредоточиться на критических событиях.

**Результаты:**

- Подробное описание CJM для сценария оформления первой платной подписки
- План отслеживания событий, фиксирующий действия пользователя в процессе выполнения этого сценария
- Приоритизация событий с описанием цепочки размышлений, позволяющей понять почему вами был выбран именно такой путь приоритизации

## 2\. Создать дашборд на тестовых данных

В качестве продуктового аналитика ваша задача — создать дашборд, который позволит ответить на ключевые вопросы о продукте на основе выборочных данных. Предоставляемые данные включают информацию о пользователе, такую как источник регистрации, статус подписки, активные виджеты и время, проведенное на платформе. Вам нужно будет проанализировать эти данные и создать дашборд, который предоставит информацию о ключевых метриках и поведении пользователей.

**Описание датасета sample_data.csv**

\- Date (YYYY-MM-DD)

\- User ID

\- Registration Source (Organic, PPC, Social Media, Referral)

\- Subscription Status (Free Trial, Monthly, Annual, Inactive)

\- Subscription Start Date (YYYY-MM-DD)

\- Subscription End Date (YYYY-MM-DD, NULL if active)

\- Number of Active Widgets (integer)

\- Number of Widget Interactions (integer)

\- Time Spent on Platform (minutes)

\- Location (Country)

**Ключевые вопросы, на которые должен отвечать дашборд:**

1. Какое общее количество пользователей для каждого источника регистрации?
2. Как распределяются статусы подписки среди пользователей платформы?
3. Сколько новых пользователей подписались на каждый план за последний месяц?
4. Какое среднее количество виджетов на пользователя в зависимости от статуса подписки?
5. В каких странах на платформе зарегистрировано наибольшее количество пользователей?
6. Как время, проведенное на платформе, различается для разных статусов подписки?
7. Как в зависимости от месяца изменяется количество регистраций новых пользователей по источникам регистрации?
8. Какое среднее время между регистрацией и обновлением или отменой подписки?
9. В какой день недели больше всего регистраций пользователей на платформе?

**Порядок выполнения:**

1. Ознакомьтесь с датасетом sample_data.csv.
2. Просмотрите предоставленный список вопросов и определите структуру дашборда, который позволил бы отвечать на эти вопросы.
3. Создайте дашборд: с помощью BI-инструмента (например DataLens, Tableau, PowerBI или Google Data Studio) создайте дашборд, отвечающий на ключевые вопросы, заданные на шаге 2. Дашборд должен быть простым для понимания и использования. Дашборд должен позволять фильтровать и сегментировать данные на основе различных критериев (набор критериев для фильтрации определите самостоятельно).
4. Создайте презентацию (не более 5 слайдов), которая показывает ключевые выводы на основе данных дашборда

**Результаты:**

- Дашборд, который отвечает на ключевые вопросы о продукте на основе предоставленного датасета.
- Презентация ключевых выводов на основе данных дашборда